<?php

// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) ){
	exit;
}
include_once 'page-header.php';
global $btnsx_settings;
$tab = ( isset( $btnsx_settings['tab'] ) && $btnsx_settings['tab'] != '' ? $btnsx_settings['tab'] : '0' );
?>
	<style type="text/css">
  		.col-pad-css {
			padding: 20px 10px 0!important;
      	}
      	.col-pad-settings {
			padding: 20px 10px!important;
      	}
      	.btn-save-css {
      		position: relative;
      	}
      	.btnsx .btn-save-css:focus {
      		background-color: #AFAFAF;
      	}
      	#btnsx-settings-css-bg {
      		position: absolute;
      		height: 100%;
      		width: 0%;
      		left: 0;
      		top: 0;
      		background-color: rgba(42, 183, 149, 0.7);
      	}
      	#btnsx-settings-css-text {
      		position: absolute;
      		height: 100%;
      		width: 100%;
      		top: 0;
      		left: 0;
      		z-index: 999;
      	}
      	.btn-save {
			background-color: <?php echo $_wp_admin_css_colors[$current_color]->colors[3]; ?> !important;
			background-image: none !important;
      	}
      	.btn-reset {
			background-color: <?php echo $_wp_admin_css_colors[$current_color]->colors[2]; ?> !important;
			background-image: none !important;
      	}
      	.btn-settings {
      		width: 100% !important;
			border: 0 !important;
			color: #fff !important;
      	}
      	.btn-settings:disabled {
      		opacity: 0.4;
      	}
      	.btnsx-sc-authenticate { border: 1px solid #ee6e73 !important; color: #ee6e73 !important; }
      	.btnsx-sc-authenticated { border: 1px solid #26a69a !important; color: #26a69a !important; }
      	.help-links a {
			color: #2196f3;
      	}
      	.help-links a:hover {
			color: #1565c0;
      	}
  	</style>
	<div class="" style="margin-right: 20px;background-color:#fcfcfc;">
		<!-- Page Content goes here -->
		<script type="text/javascript">
		jQuery(document).ready(function($){
			$( '#btnsx-tabs-0' ).find('nav ul li:eq(<?php echo $tab; ?>)').trigger('click');
			$('.btnsx-select').each(function(){
				$(this).select2();
			});
			// console.log(window.location.hash);
			var ig_token = document.URL.substr(document.URL.indexOf('#')+1);
			if( window.location.hash != '' ){
				ig_token = ig_token.replace( 'access_token=', '' );
				$('#social_counters_ig_access_token').val(ig_token);
			}
			$('#after_content_margin_all').on('input propertychange keyup',function(){
				var val = $(this).val();
				$('#after_content_margin_top,#after_content_margin_bottom,#after_content_margin_left,#after_content_margin_right').val(val);
			});
			$('#before_content_margin_all').on('input propertychange keyup',function(){
				var val = $(this).val();
				$('#before_content_margin_top,#before_content_margin_bottom,#before_content_margin_left,#before_content_margin_right').val(val);
			});
		});
		</script>
		<div class="row">
			<form id="btnsx-settings-form" name="btnsx-settings-form" method="post" action="">
				<?php settings_fields( 'btnsx_settings_group' ); ?>
		    	<div class="col m12 l9" style="padding:0;">
		        	<!-- page content  -->
					<?php
					$post_types = get_post_types( array( 'public' => true ) );
					$post_types_filter = array( 'attachment', 'buttons-x', 'buttons-x-social' );
					foreach( $post_types_filter as $key ) {
					   unset( $post_types[ $key ] );
					}
					$button_cpt = new BtnsxFormElements();
		        	$btnsx_default_options = array(
		        		array(
		        			'icon_class'	=>	'fa fa-pencil',
		        			'text'			=>	__( 'Automatic Updates', 'btnsx' ),
		        			'elements'		=> array(
								array(
									'type'			=>	'text',
									'name'			=>	'purchase_code',
									'label'			=>	__( 'Purchase Code', 'btnsx' ),
									'tooltip'		=>	__( 'Get your Purchase Code from the downloads page on Envato Market or from the email you received when you bought the plugin.<br> Check this image - <a target="_blank" href="http://btn.sx/1TYvovf">http://btn.sx/1TYvovf</a>.', 'btnsx' ),
									'value'			=>	isset( $btnsx_settings['purchase_code'] ) && $btnsx_settings['purchase_code'] != '' ? $btnsx_settings['purchase_code'] : ''
								)
							),
						),
		        		array(
		        			'icon_class'	=>	'fa fa-pencil',
		        			'text'			=>	__( 'General', 'btnsx' ),
		        			'elements'		=> array(
								array(
									'type'			=>	'radio',
									'name'			=>	'css',
									'label'			=>	__( 'CSS', 'btnsx' ),
									'tooltip'		=>	__( 'Select CSS to be displayed inline or through external file.', 'btnsx' ),
									'options'		=>	array(
										'css_external'	=>	'external',
										'css_inline'	=>	'inline'
									),
									'value'			=>	isset( $btnsx_settings['css'] ) && $btnsx_settings['css'] != '' ? $btnsx_settings['css'] : 'inline'
								),
								array(
									'type'			=>	'switch',
									'name'			=>	'dual_buttons',
									'class'			=>	'btnsx-checkbox',
									'label'			=>	__( 'Dual Buttons', 'btnsx' ),
									'on_text'		=>	__( 'ON', 'btnsx' ),
									'off_text'		=>	__( 'OFF', 'btnsx' ),
									'tooltip'		=>	__( 'Enable or disable dual buttons.', 'btnsx' ),
									'value'			=>	isset( $btnsx_settings['dual_buttons'] ) && $btnsx_settings['dual_buttons'] != '' ? $btnsx_settings['dual_buttons'] : '0'
								),
								array(
									'type'			=>	'switch',
									'name'			=>	'social_buttons',
									'class'			=>	'btnsx-checkbox',
									'label'			=>	__( 'Social Buttons', 'btnsx' ),
									'on_text'		=>	__( 'ON', 'btnsx' ),
									'off_text'		=>	__( 'OFF', 'btnsx' ),
									'tooltip'		=>	__( 'Enable or disable social buttons.', 'btnsx' ),
									'value'			=>	isset( $btnsx_settings['social_buttons'] ) && $btnsx_settings['social_buttons'] != '' ? $btnsx_settings['social_buttons'] : '0'
								),
								array(
									'type'			=>	'switch',
									'name'			=>	'social_counters',
									'class'			=>	'btnsx-checkbox',
									'label'			=>	__( 'Social Counters', 'btnsx' ),
									'on_text'		=>	__( 'ON', 'btnsx' ),
									'off_text'		=>	__( 'OFF', 'btnsx' ),
									'tooltip'		=>	__( 'Enable or disable social counters.', 'btnsx' ),
									'value'			=>	isset( $btnsx_settings['social_counters'] ) && $btnsx_settings['social_counters'] != '' ? $btnsx_settings['social_counters'] : '0'
								),
								array(
									'type'			=>	'switch',
									'name'			=>	'auto_responsive_styles',
									'class'			=>	'btnsx-checkbox',
									'label'			=>	__( 'Auto Responsive Style for Single Buttons', 'btnsx' ),
									'on_text'		=>	__( 'ON', 'btnsx' ),
									'off_text'		=>	__( 'OFF', 'btnsx' ),
									'tooltip'		=>	__( 'Enable or disable automatic responsive styles for single buttons.', 'btnsx' ),
									'value'			=>	isset( $btnsx_settings['auto_responsive_styles'] ) && $btnsx_settings['auto_responsive_styles'] != '' ? $btnsx_settings['auto_responsive_styles'] : '0'
								),
							),
						),
		        		array(
		        			'icon_class'	=>	'fa fa-tablet',
		        			'text'			=>	__( 'Responsive', 'btnsx' ),
		        			'elements'		=> array(
		        				array(
									'type'			=>	'text',
									'id'			=>	'responsive_tablet_width',
									'name'			=>	'responsive_tablet_width',
									'label'			=>	__( 'Tablet Width', 'btnsx' ),
									'tooltip'		=>	__( 'Set the tablet screen width in pixels. When the screen size is equal or below this tablet width then the responsive tablet settings will take over.', 'btnsx' ),
									'value'			=>	isset( $btnsx_settings['responsive_tablet_width'] ) && $btnsx_settings['responsive_tablet_width'] != '' ? $btnsx_settings['responsive_tablet_width'] : '768'
								),
								array(
									'type'			=>	'text',
									'id'			=>	'responsive_mobile_width',
									'name'			=>	'responsive_mobile_width',
									'label'			=>	__( 'Mobile Width', 'btnsx' ),
									'tooltip'		=>	__( 'Set the mobile screen width in pixels. When the screen size is equal or below this mobile width then the responsive mobile settings will take over.', 'btnsx' ),
									'value'			=>	isset( $btnsx_settings['responsive_mobile_width'] ) && $btnsx_settings['responsive_mobile_width'] != '' ? $btnsx_settings['responsive_mobile_width'] : '480'
								),
							),
						)
			        );
					$btnsx_form = new BtnsxFormElements();
			        $btnsx_default_options[] = array(
	        			'icon_class'	=>	'fa fa-file-text-o',
	        			'text'			=>	__( 'Content Filter', 'btnsx' ),
	        			'inner_group'	=> array(
	        				array(
		        				'text'			=>	__( 'After Content', 'btnsx' ),
								'elements'		=> array(
									array(
										'type'			=>	'select',
										'name'			=>	'after_content_post_types[]',
										'multiselect'	=>	true,
										'class'			=>	'btnsx-select',
										'label'			=>	__( 'Post Types', 'btnsx' ),
										'tooltip'		=>	__( 'Select the post types on which you want buttons to be displayed after content.', 'btnsx' ),
										'options'		=>	$btnsx_form->get_post_types( array('attachment') ),
										'value'			=>	isset( $btnsx_settings['after_content_post_types'] ) && $btnsx_settings['after_content_post_types'] != '' ? $btnsx_settings['after_content_post_types'] : array('post','page'),
									),
									array(
										'type'			=>	'select',
										'cpt'			=>	array('buttons-x','buttons-x-social','buttons-x-dual','buttons-x-cs'),
										'multiselect'	=>	true,
										'name'			=>	'after_content_buttons[]',
										'label'			=>	__( 'Buttons', 'btnsx' ),
										'tooltip'		=>	__( 'Select the buttons you want to display after every post, page or custom post type selected above.', 'btnsx' ),
										'options'		=>	$btnsx_form->cpt( 'buttons-x', isset( $btnsx_settings['after_content_buttons'] ) && $btnsx_settings['after_content_buttons'] != '' ? $btnsx_settings['after_content_buttons'] : array() ),
										'value'			=>	isset( $btnsx_settings['after_content_buttons'] ) && is_array($btnsx_settings['after_content_buttons']) ? $btnsx_settings['after_content_buttons'] : array(),
									),
									array(
										'type'			=>	'text',
										'id'			=>	'after_content_priority',
										'name'			=>	'after_content_priority',
										'label'			=>	__( 'Priority', 'btnsx' ),
										'tooltip'		=>	__( 'The higher the priority value the later the button will appear. Helpful when some other plugins add custom content after post content.', 'btnsx' ),
										'value'			=>	isset( $btnsx_settings['after_content_priority'] ) && $btnsx_settings['after_content_priority'] != '' ? $btnsx_settings['after_content_priority'] : '10'
									),
									array(
										'type'			=>	'checkbox',
										'id'			=>	'after_content_wrap_center',
										'name'			=>	'after_content_wrap_center',
										'label'			=>	__( 'Wrap Center', 'btnsx' ),
										'tooltip'		=>	__( 'Make the buttons appear centered.', 'btnsx' ),
										'class'			=>	'btnsx-checkbox',
										'value'			=>	isset( $btnsx_settings['after_content_wrap_center'] ) && $btnsx_settings['after_content_wrap_center'] != '' ? $btnsx_settings['after_content_wrap_center'] : '0'
									),
									array(
										'type'			=>	'html',
										'value'			=>	'<div class="col m12"><br><p><strong>' . __('Container Margin','btnsx') . '</strong></p><div class="divider"></div><br></div>'	
									),
									array(
										'type'			=>	'trbl',
										'id'			=>	'after_content_margin',
										'name'			=>	'after_content_margin',
										'placeholder'	=>	'',
										'tooltip'		=>	array(
											'all'			=>	__( 'Set margin for all sides. This field is not saved. It should be used to apply same margin value to all sides.', 'btnsx' ),
											'top'			=>	__( 'Set top margin for button.', 'btnsx' ),
											'bottom'		=>	__( 'Set bottom margin for button.', 'btnsx' ),
											'left'			=>	__( 'Set left margin for button.', 'btnsx' ),
											'right'			=>	__( 'Set right margin for button.', 'btnsx' ),
										),
										'value'			=>	array(
											'top'			=>	isset( $btnsx_settings['after_content_margin_top'] ) && $btnsx_settings['after_content_margin_top'] != '' ? $btnsx_settings['after_content_margin_top'] : '0',
											'bottom'		=>	isset( $btnsx_settings['after_content_margin_bottom'] ) && $btnsx_settings['after_content_margin_bottom'] != '' ? $btnsx_settings['after_content_margin_bottom'] : '0',
											'left'			=>	isset( $btnsx_settings['after_content_margin_left'] ) && $btnsx_settings['after_content_margin_left'] != '' ? $btnsx_settings['after_content_margin_left'] : '0',
											'right'			=>	isset( $btnsx_settings['after_content_margin_right'] ) && $btnsx_settings['after_content_margin_right'] != '' ? $btnsx_settings['after_content_margin_right'] : '0'
										)
									)
								)
							),
							array(
		        				'text'			=>	__( 'Before Content', 'btnsx' ),
								'elements'		=> array(
									array(
										'type'			=>	'select',
										'multiselect'	=>	true,
										'name'			=>	'before_content_post_types[]',
										'label'			=>	__( 'Post Types', 'btnsx' ),
										'tooltip'		=>	__( 'Select the post types on which you want buttons to be displayed before content.', 'btnsx' ),
										'options'		=>	$btnsx_form->get_post_types( array('attachment') ),
										'value'			=>	isset( $btnsx_settings['before_content_post_types'] ) && $btnsx_settings['before_content_post_types'] != '' ? $btnsx_settings['before_content_post_types'] : array('post','page'),
									),
									array(
										'type'			=>	'select',
										'cpt'			=>	array('buttons-x','buttons-x-social','buttons-x-dual','buttons-x-cs'),
										'multiselect'	=>	true,
										'name'			=>	'before_content_buttons[]',
										'label'			=>	__( 'Buttons', 'btnsx' ),
										'tooltip'		=>	__( 'Select the buttons you want to display after every post, page or custom post type selected above.', 'btnsx' ),
										'options'		=>	$btnsx_form->cpt( 'buttons-x', isset( $btnsx_settings['before_content_buttons'] ) && $btnsx_settings['before_content_buttons'] != '' ? $btnsx_settings['before_content_buttons'] : array() ),
										'value'			=>	isset( $btnsx_settings['before_content_buttons'] ) && $btnsx_settings['before_content_buttons'] != '' ? $btnsx_settings['before_content_buttons'] : array(),
									),
									array(
										'type'			=>	'text',
										'id'			=>	'before_content_priority',
										'name'			=>	'before_content_priority',
										'label'			=>	__( 'Priority', 'btnsx' ),
										'tooltip'		=>	__( 'The higher the priority value the earlier the button will appear. Helpful when some other plugins add custom content before post data.', 'btnsx' ),
										'value'			=>	isset( $btnsx_settings['before_content_priority'] ) && $btnsx_settings['before_content_priority'] != '' ? $btnsx_settings['before_content_priority'] : '10'
									),
									array(
										'type'			=>	'checkbox',
										'id'			=>	'before_content_wrap_center',
										'name'			=>	'before_content_wrap_center',
										'label'			=>	__( 'Wrap Center', 'btnsx' ),
										'tooltip'		=>	__( 'Make the buttons appear centered.', 'btnsx' ),
										'class'			=>	'btnsx-checkbox',
										'value'			=>	isset( $btnsx_settings['before_content_wrap_center'] ) && $btnsx_settings['before_content_wrap_center'] != '' ? $btnsx_settings['before_content_wrap_center'] : '0'
									),
									array(
										'type'			=>	'html',
										'value'			=>	'<div class="col m12"><br><p><strong>' . __('Container Margin','btnsx') . '</strong></p><div class="divider"></div><br></div>'	
									),
									array(
										'type'			=>	'trbl',
										'id'			=>	'before_content_margin',
										'name'			=>	'before_content_margin',
										'placeholder'	=>	'',
										'tooltip'		=>	array(
											'all'			=>	__( 'Set margin for all sides. This field is not saved. It should be used to apply same margin value to all sides.', 'btnsx' ),
											'top'			=>	__( 'Set top margin for button.', 'btnsx' ),
											'bottom'		=>	__( 'Set bottom margin for button.', 'btnsx' ),
											'left'			=>	__( 'Set left margin for button.', 'btnsx' ),
											'right'			=>	__( 'Set right margin for button.', 'btnsx' ),
										),
										'value'			=>	array(
											'top'			=>	isset( $btnsx_settings['before_content_margin_top'] ) && $btnsx_settings['before_content_margin_top'] != '' ? $btnsx_settings['before_content_margin_top'] : '0',
											'bottom'		=>	isset( $btnsx_settings['before_content_margin_bottom'] ) && $btnsx_settings['before_content_margin_bottom'] != '' ? $btnsx_settings['before_content_margin_bottom'] : '0',
											'left'			=>	isset( $btnsx_settings['before_content_margin_left'] ) && $btnsx_settings['before_content_margin_left'] != '' ? $btnsx_settings['before_content_margin_left'] : '0',
											'right'			=>	isset( $btnsx_settings['before_content_margin_right'] ) && $btnsx_settings['before_content_margin_right'] != '' ? $btnsx_settings['before_content_margin_right'] : '0'
										)
									)
								)
							)
						),
					);
					if( isset( $btnsx_settings['social_buttons'] ) && $btnsx_settings['social_buttons'] === '1' ) {
						$btnsx_default_options[] = array(
		        			'icon_class'	=>	'fa fa-share-square-o',
		        			'text'			=>	__( 'Social', 'btnsx' ),
		        			'elements'		=> array(
								array(
									'type'			=>	'select',
									'multiselect'	=>	true,
									'name'			=>	'social[]',
									'label'			=>	__( 'Social Post Types', 'btnsx' ),
									'tooltip'		=>	__( 'Social buttons meta box will appear on these post types.', 'btnsx' ),
									'options'		=>	$post_types,
									'value'			=>	isset( $btnsx_settings['social'] ) && $btnsx_settings['social'] != '' ? $btnsx_settings['social'] : array( 'post', 'page' )
								),
							),
						);
					}
					if( isset( $btnsx_settings['social_counters'] ) && $btnsx_settings['social_counters'] === '1' ) {
						$fb_access_token = isset( $btnsx_settings['social_counters_fb_access_token'] ) && $btnsx_settings['social_counters_fb_access_token'] != '' ? $btnsx_settings['social_counters_fb_access_token'] : '';
						$fb_btn_access = isset( $btnsx_settings['social_counters_fb_access_token'] ) && $btnsx_settings['social_counters_fb_access_token'] != '' ? __( 'Authenticated', 'btnsx') : __( 'Authenticate', 'btnsx');
						$fb_btn_class = isset( $fb_btn_access ) && $fb_btn_access == 'Authenticated' ? 'btnsx-sc-authenticated' : 'btnsx-sc-authenticate';
						$tw_access_token = isset( $btnsx_settings['social_counters_tw_access_token'] ) && $btnsx_settings['social_counters_tw_access_token'] != '' ? $btnsx_settings['social_counters_tw_access_token'] : '';
						$tw_btn_access = isset( $btnsx_settings['social_counters_tw_access_token'] ) && $btnsx_settings['social_counters_tw_access_token'] != '' ? __( 'Authenticated', 'btnsx') : __( 'Authenticate', 'btnsx');
						$tw_btn_class = isset( $tw_btn_access ) && $tw_btn_access == 'Authenticated' ? 'btnsx-sc-authenticated' : 'btnsx-sc-authenticate';
						$ig_access_token = isset( $btnsx_settings['social_counters_ig_access_token'] ) && $btnsx_settings['social_counters_ig_access_token'] != '' ? $btnsx_settings['social_counters_ig_access_token'] : '';
						$ig_btn_access = isset( $btnsx_settings['social_counters_ig_access_token'] ) && $btnsx_settings['social_counters_ig_access_token'] != '' ? __( 'Authenticated', 'btnsx') : __( 'Authenticate', 'btnsx');
						$ig_btn_class = isset( $ig_btn_access ) && $ig_btn_access == 'Authenticated' ? 'btnsx-sc-authenticated' : 'btnsx-sc-authenticate';
						$li_access_token = isset( $btnsx_settings['social_counters_li_access_token'] ) && $btnsx_settings['social_counters_li_access_token'] != '' ? $btnsx_settings['social_counters_li_access_token'] : '';
						$li_btn_access = isset( $btnsx_settings['social_counters_li_access_token'] ) && $btnsx_settings['social_counters_li_access_token'] != '' ? __( 'Authenticated', 'btnsx') : __( 'Authenticate', 'btnsx');
						$li_btn_class = isset( $li_btn_access ) && $li_btn_access == 'Authenticated' ? 'btnsx-sc-authenticated' : 'btnsx-sc-authenticate';
						$pi_access_token = isset( $btnsx_settings['social_counters_pi_access_token'] ) && $btnsx_settings['social_counters_pi_access_token'] != '' ? $btnsx_settings['social_counters_pi_access_token'] : '';
						$pi_btn_access = isset( $btnsx_settings['social_counters_pi_access_token'] ) && $btnsx_settings['social_counters_pi_access_token'] != '' ? __( 'Authenticated', 'btnsx') : __( 'Authenticate', 'btnsx');
						$pi_btn_class = isset( $pi_btn_access ) && $pi_btn_access == 'Authenticated' ? 'btnsx-sc-authenticated' : 'btnsx-sc-authenticate';
						$si_access_token = isset( $btnsx_settings['social_counters_si_access_token'] ) && $btnsx_settings['social_counters_si_access_token'] != '' ? $btnsx_settings['social_counters_si_access_token'] : '';
						$si_btn_access = isset( $btnsx_settings['social_counters_si_access_token'] ) && $btnsx_settings['social_counters_si_access_token'] != '' ? __( 'Authenticated', 'btnsx') : __( 'Authenticate', 'btnsx');
						$si_btn_class = isset( $si_btn_access ) && $si_btn_access == 'Authenticated' ? 'btnsx-sc-authenticated' : 'btnsx-sc-authenticate';
						echo '<input type="hidden" id="social_counters_fb_access_token" name="social_counters_fb_access_token" placeholder="" value="'.$fb_access_token.'">';
						echo '<input type="hidden" id="social_counters_tw_access_token" name="social_counters_tw_access_token" placeholder="" value="'.$tw_access_token.'">';
						echo '<input type="hidden" id="social_counters_ig_access_token" name="social_counters_ig_access_token" placeholder="" value="'.$ig_access_token.'">';
						echo '<input type="hidden" id="social_counters_li_access_token" name="social_counters_li_access_token" placeholder="" value="'.$li_access_token.'">';
						echo '<input type="hidden" id="social_counters_si_access_token" name="social_counters_si_access_token" placeholder="" value="'.$si_access_token.'">';
						$btnsx_default_options[] = array(
		        			'icon_class'	=>	'fa fa-share-square-o',
		        			'text'			=>	__( 'Social Counters', 'btnsx' ),
		        			'elements'		=> array(
								array(
									'type'			=>	'text',
									'id'			=>	'social_counters_cache',
									'name'			=>	'social_counters_cache',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Cache Time', 'btnsx' ),
									'tooltip'		=>	__( 'Clears cache after the specified period of time (in hours). Default is 24 hours.', 'btnsx' ),
									'value'			=>	isset( $btnsx_settings['social_counters_cache'] ) && $btnsx_settings['social_counters_cache'] != '' ? $btnsx_settings['social_counters_cache'] : '24'
								),
							),
							'inner_group'		=> array(
								array(
									'text'	=>	__( '500px', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_fivepx_api_key',
											'name'			=>	'social_counters_fivepx_api_key',
											'placeholder'	=>	' ',
											'label'			=>	__( '500px Consumer Key', 'btnsx' ),
											'tooltip'		=>	__( 'Please create an app through this link:<a target="_blank" href="https://500px.com/settings/applications">https://500px.com/settings/applications</a> and get this information.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_fivepx_api_key'] ) && $btnsx_settings['social_counters_fivepx_api_key'] != '' ? $btnsx_settings['social_counters_fivepx_api_key'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_fivepx_user_id',
											'name'			=>	'social_counters_fivepx_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( '500px User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Add ID', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_fivepx_user_id'] ) && $btnsx_settings['social_counters_fivepx_user_id'] != '' ? $btnsx_settings['social_counters_fivepx_user_id'] : ''
										),
									)
								),
								array(
									'text'	=>	__( 'Behance', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_be_client_id',
											'name'			=>	'social_counters_be_client_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Behance Client ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please register an app on Behance through this link:<a target="_blank" href="https://www.behance.net/dev/register">https://www.behance.net/dev/register</a> and get the "API KEY / CLIENT ID".', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_be_client_id'] ) && $btnsx_settings['social_counters_be_client_id'] != '' ? $btnsx_settings['social_counters_be_client_id'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_be_user_id',
											'name'			=>	'social_counters_be_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Behance User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the user ID. For example:If your profile url is https://www.behance.net/TommyRoussel then your user ID is TommyRoussel.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_be_user_id'] ) && $btnsx_settings['social_counters_be_user_id'] != '' ? $btnsx_settings['social_counters_be_user_id'] : ''
										),
									)
								),
								array(
									'text'	=>	__( 'Delicious', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_del_user_id',
											'name'			=>	'social_counters_del_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Delicious User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the user ID. For example:If your profile url is <a target="_blank" href="https://delicious.com/jdevalk">https://delicious.com/jdevalk</a> then your user ID is jdevalk.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_del_user_id'] ) && $btnsx_settings['social_counters_del_user_id'] != '' ? $btnsx_settings['social_counters_del_user_id'] : ''
										),
									)
								),
								array(
									'text'	=>	__( 'Dribbble', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_db_token',
											'name'			=>	'social_counters_db_token',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Dribbble Access Token', 'btnsx' ),
											'tooltip'		=>	__( 'Please create an app on Dribbble through this link: <a target="_blank" href="https://dribbble.com/account/applications/new">https://dribbble.com/account/applications/new</a> and get the access token.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_db_token'] ) && $btnsx_settings['social_counters_db_token'] != '' ? $btnsx_settings['social_counters_db_token'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_db_user_id',
											'name'			=>	'social_counters_db_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Dribbble User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the user ID.For example:If your page url is https://dribbble.com/madebyradio/ then your user ID is madebyradio.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_db_user_id'] ) && $btnsx_settings['social_counters_db_user_id'] != '' ? $btnsx_settings['social_counters_db_user_id'] : ''
										),
									)
								),
								array(
									'text'	=>	__( 'Envato', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_env_token',
											'name'			=>	'social_counters_env_token',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Envato Personal Token', 'btnsx' ),
											'tooltip'		=>	__( 'Please create a personal token on Envato through this link: <a target="_blank" href="https://build.envato.com/create-token/ ">https://build.envato.com/create-token/</a> and get the personal access token.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_env_token'] ) && $btnsx_settings['social_counters_env_token'] != '' ? $btnsx_settings['social_counters_env_token'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_env_user_id',
											'name'			=>	'social_counters_env_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Envato User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the user ID. For example:If your page url is http://codecanyon.net/user/gautamthapar/ then your user ID is gautamthapar.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_env_user_id'] ) && $btnsx_settings['social_counters_env_user_id'] != '' ? $btnsx_settings['social_counters_env_user_id'] : ''
										),
										array(
											'type'			=>	'select',
											'id'			=>	'social_counters_env_site',
											'name'			=>	'social_counters_env_site',
											'class'			=>	'btnsx-select',
											'label'			=>	__( 'Envato Site', 'btnsx' ),
											'tooltip'		=>	__( 'Please select the Envato site where you want visitors to redirected on button click.', 'btnsx' ),
											'options'		=>	array(
												'themeforest.net'	=>	__( 'themeforest', 'btnsx' ),
												'codecanyon.net'	=>	__( 'codecanyon', 'btnsx' ),
												'videohive.net'	=>	__( 'videohive', 'btnsx' ),
												'audiojungle.net'	=>	__( 'audiojungle', 'btnsx' ),
												'graphicriver.net'	=>	__( 'graphicriver', 'btnsx' ),
												'photodune.net'	=>	__( 'photodune', 'btnsx' ),
												'3docean.net'	=>	__( '3docean', 'btnsx' ),
											),
											'value'			=>	isset( $btnsx_settings['social_counters_env_site'] ) && $btnsx_settings['social_counters_env_site'] != '' ? $btnsx_settings['social_counters_env_site'] : ''
										)
												)
								),
								array(
									'text'	=>	__( 'Facebook', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_fb_app_id',
											'name'			=>	'social_counters_fb_app_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Facebook App ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please create an app on Facebook through this link:<a target="_blank" href="https://developers.facebook.com/apps">https://developers.facebook.com/apps</a> and get this information.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_fb_app_id'] ) && $btnsx_settings['social_counters_fb_app_id'] != '' ? $btnsx_settings['social_counters_fb_app_id'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_fb_app_secret',
											'name'			=>	'social_counters_fb_app_secret',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Facebook App Secret', 'btnsx' ),
											'tooltip'		=>	__( 'Please create an app on Facebook through this link:https://developers.facebook.com/apps and get this information.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_fb_app_secret'] ) && $btnsx_settings['social_counters_fb_app_secret'] != '' ? $btnsx_settings['social_counters_fb_app_secret'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_fb_page_id',
											'name'			=>	'social_counters_fb_page_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Facebook Page ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the page ID or page name.For example:If your page url is https://www.facebook.com/btnsx/ then your page ID is btnsx.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_fb_page_id'] ) && $btnsx_settings['social_counters_fb_page_id'] != '' ? $btnsx_settings['social_counters_fb_page_id'] : ''
										),
										array(
											'type'			=>	'html',
											'value'			=>	( isset( $btnsx_settings['social_counters_fb_app_id'] ) && $btnsx_settings['social_counters_fb_app_id'] != '' ) && ( isset( $btnsx_settings['social_counters_fb_app_secret'] ) && $btnsx_settings['social_counters_fb_app_secret'] != '' ) ? '<a id="facebook-oauth" class="btn '.$fb_btn_class.'" href="" style="margin-left:10px;">'.$fb_btn_access.'</a>' : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Github', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_gh_token',
											'name'			=>	'social_counters_gh_token',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Github Personal Token', 'btnsx' ),
											'tooltip'		=>	__( 'Please create a personal token on Github through this link: <a href="https://github.com/settings/tokens/new">https://github.com/settings/tokens/new</a> and get the personal access token.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_gh_token'] ) && $btnsx_settings['social_counters_gh_token'] != '' ? $btnsx_settings['social_counters_gh_token'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_gh_user_id',
											'name'			=>	'social_counters_gh_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Github User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the user ID. For example:If your page url is https://github.com/nacin then your channel ID is nacin.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_gh_user_id'] ) && $btnsx_settings['social_counters_gh_user_id'] != '' ? $btnsx_settings['social_counters_gh_user_id'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Goodreads', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_gr_api_key',
											'name'			=>	'social_counters_gr_api_key',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Goodreads API Key', 'btnsx' ),
											'tooltip'		=>	__( 'Please create an app on Goodreads through this link: <a href="https://www.goodreads.com/api/keys">https://www.goodreads.com/api/keys</a> and get the API key.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_gr_api_key'] ) && $btnsx_settings['social_counters_gr_api_key'] != '' ? $btnsx_settings['social_counters_gr_api_key'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_gr_user_id',
											'name'			=>	'social_counters_gr_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Goodreads User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Add ID', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_gr_user_id'] ) && $btnsx_settings['social_counters_gr_user_id'] != '' ? $btnsx_settings['social_counters_gr_user_id'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Google+', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_gp_api_key',
											'name'			=>	'social_counters_gp_api_key',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Google+ API Key', 'btnsx' ),
											'tooltip'		=>	__( 'Please create a project through this link: <a target="_blank" href="https://console.developers.google.com/">https://console.developers.google.com/</a> and get the API key.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_gp_api_key'] ) && $btnsx_settings['social_counters_gp_api_key'] != '' ? $btnsx_settings['social_counters_gp_api_key'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_gp_page_id',
											'name'			=>	'social_counters_gp_page_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Google+ Page ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the page ID or page name.For example:If your page url is https://plus.google.com/+Mashable/ then your page ID is +Mashable OR if your page url is https://plus.google.com/104009217652352075079/ then your page ID is 104009217652352075079.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_gp_page_id'] ) && $btnsx_settings['social_counters_gp_page_id'] != '' ? $btnsx_settings['social_counters_gp_page_id'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Instagram', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_ig_client_id',
											'name'			=>	'social_counters_ig_client_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Instagram Client ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please register an app on Instagram through this link:<a target="_blank" href="https://instagram.com/developer/clients/register/">https://instagram.com/developer/clients/register/</a> and get the "CLIENT ID".', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_ig_client_id'] ) && $btnsx_settings['social_counters_ig_client_id'] != '' ? $btnsx_settings['social_counters_ig_client_id'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_ig_redirect_uri',
											'name'			=>	'social_counters_ig_redirect_uri',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Instagram Redirect URI', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the Redirect URI.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_ig_redirect_uri'] ) && $btnsx_settings['social_counters_ig_redirect_uri'] != '' ? $btnsx_settings['social_counters_ig_redirect_uri'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_ig_user_id',
											'name'			=>	'social_counters_ig_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Instagram User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the user ID. For example:If your profile url is <a target="_blank" href="https://www.instagram.com/gautam_thapar/">https://www.instagram.com/gautam_thapar/</a> then your user ID is gautam_thapar.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_ig_user_id'] ) && $btnsx_settings['social_counters_ig_user_id'] != '' ? $btnsx_settings['social_counters_ig_user_id'] : ''
										),
										array(
											'type'			=>	'html',
											'value'			=>	( isset( $btnsx_settings['social_counters_ig_client_id'] ) && $btnsx_settings['social_counters_ig_client_id'] != '' ) && ( isset( $btnsx_settings['social_counters_ig_redirect_uri'] ) && $btnsx_settings['social_counters_ig_redirect_uri'] != '' ) ? '<a id="instagram-oauth" class="btn '.$ig_btn_class.'" href="" style="margin-left:10px;">'.$ig_btn_access.'</a>' : ''
										)
									)
								),
								array(
									'text'	=>	__( 'LinkedIn', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_li_client_id',
											'name'			=>	'social_counters_li_client_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'LinkedIn Client ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please register an app on LinkedIn through this link:<a target="_blank" href="https://www.linkedin.com/secure/developer?newapp=">https://www.linkedin.com/secure/developer?newapp=</a> and get the "Client ID".', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_li_client_id'] ) && $btnsx_settings['social_counters_li_client_id'] != '' ? $btnsx_settings['social_counters_li_client_id'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_li_client_secret',
											'name'			=>	'social_counters_li_client_secret',
											'placeholder'	=>	' ',
											'label'			=>	__( 'LinkedIn Client Secret', 'btnsx' ),
											'tooltip'		=>	__( 'Please register an app on LinkedIn through this link:<a target="_blank" href="https://www.linkedin.com/secure/developer?newapp=">https://www.linkedin.com/secure/developer?newapp=</a> and get the "Client Secret".', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_li_client_secret'] ) && $btnsx_settings['social_counters_li_client_secret'] != '' ? $btnsx_settings['social_counters_li_client_secret'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_li_redirect_uri',
											'name'			=>	'social_counters_li_redirect_uri',
											'placeholder'	=>	' ',
											'label'			=>	__( 'LinkedIn Redirect URL', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the Redirect URL.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_li_redirect_uri'] ) && $btnsx_settings['social_counters_li_redirect_uri'] != '' ? $btnsx_settings['social_counters_li_redirect_uri'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_li_user_id',
											'name'			=>	'social_counters_li_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'LinkedIn Profile URL', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter profile URL. For example: https://in.linkedin.com/in/gautam-thapar-01406852 or https://www.linkedin.com/in/gautamthapar.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_li_user_id'] ) && $btnsx_settings['social_counters_li_user_id'] != '' ? $btnsx_settings['social_counters_li_user_id'] : ''
										),
										array(
											'type'			=>	'html',
											'value'			=>	( isset( $btnsx_settings['social_counters_li_client_id'] ) && $btnsx_settings['social_counters_li_client_id'] != '' ) && ( isset( $btnsx_settings['social_counters_li_redirect_uri'] ) && $btnsx_settings['social_counters_li_redirect_uri'] != '' ) ? '<a id="linkedin-oauth" class="btn '.$li_btn_class.'" href="" style="margin-left:10px;">'.$li_btn_access.'</a>' : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Mailchimp', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_mc_api_key',
											'name'			=>	'social_counters_mc_api_key',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Mailchimp API Key', 'btnsx' ),
											'tooltip'		=>	__( 'Follow the instructions mentioned here - <a target="_blank" href="https://gautamthapar.atlassian.net/wiki/display/BX/MailChimp">https://gautamthapar.atlassian.net/wiki/display/BX/MailChimp</a>. ', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_mc_api_key'] ) && $btnsx_settings['social_counters_mc_api_key'] != '' ? $btnsx_settings['social_counters_mc_api_key'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_mc_list_id',
											'name'			=>	'social_counters_mc_list_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Mailchimp List ID', 'btnsx' ),
											'tooltip'		=>	__( 'Follow the instructions mentioned here - <a target="_blank" href="https://gautamthapar.atlassian.net/wiki/display/BX/MailChimp">https://gautamthapar.atlassian.net/wiki/display/BX/MailChimp</a>. ', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_mc_list_id'] ) && $btnsx_settings['social_counters_mc_list_id'] != '' ? $btnsx_settings['social_counters_mc_list_id'] : ''
										),
										array(
											'type'			=>	'select',
											'id'			=>	'social_counters_mc_type',
											'name'			=>	'social_counters_mc_type',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Mailchimp Display Type', 'btnsx' ),
											'tooltip'		=>	__( 'Select whether to display all subscribers or just the subscribers subscribed to a single list.', 'btnsx' ),
											'options'		=>	array(
												'total'	=>	__( 'Total Subscribers', 'btnsx' ),
												'list'	=>	__( 'List Subscribers', 'btnsx' ),
											),
											'value'			=>	isset( $btnsx_settings['social_counters_mc_type'] ) && $btnsx_settings['social_counters_mc_type'] != '' ? $btnsx_settings['social_counters_mc_type'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Mixcloud', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_mix_user_id',
											'name'			=>	'social_counters_mix_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Mixcloud User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Add ID', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_mix_user_id'] ) && $btnsx_settings['social_counters_mix_user_id'] != '' ? $btnsx_settings['social_counters_mix_user_id'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Pinterest', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_pi_user_id',
											'name'			=>	'social_counters_pi_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Pinterest User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Add ID', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_pi_user_id'] ) && $btnsx_settings['social_counters_pi_user_id'] != '' ? $btnsx_settings['social_counters_pi_user_id'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'RSS', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_rss_count',
											'name'			=>	'social_counters_rss_count',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Subscribers Count', 'btnsx' ),
											'tooltip'		=>	__( 'Add subscribers count manually.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_rss_count'] ) && $btnsx_settings['social_counters_rss_count'] != '' ? $btnsx_settings['social_counters_rss_count'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_rss_url',
											'name'			=>	'social_counters_rss_url',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Feed URL', 'btnsx' ),
											'tooltip'		=>	__( 'RSS feed URL', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_rss_url'] ) && $btnsx_settings['social_counters_rss_url'] != '' ? $btnsx_settings['social_counters_rss_url'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'SoundCloud', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_sc_client_id',
											'name'			=>	'social_counters_sc_client_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'SoundCloud Client ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please register an app on SoundCloud through this link:<a target="_blank" href="http://soundcloud.com/you/apps/new">http://soundcloud.com/you/apps/new</a> and get the client ID.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_sc_client_id'] ) && $btnsx_settings['social_counters_sc_client_id'] != '' ? $btnsx_settings['social_counters_sc_client_id'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_sc_user_id',
											'name'			=>	'social_counters_sc_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'SoundCloud User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the user ID. For example:If your profile url is https://soundcloud.com/gautam-thapar then your user ID is gautam-thapar.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_sc_user_id'] ) && $btnsx_settings['social_counters_sc_user_id'] != '' ? $btnsx_settings['social_counters_sc_user_id'] : ''
										),
									)
								),
								array(
									'text'	=>	__( 'Spotify', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_si_user_id',
											'name'			=>	'social_counters_si_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Spotify Artist/User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the user ID. For example: If your profile url is https://play.spotify.com/user/david_guetta_ then your user ID is david_guetta_ OR If your profile url is https://play.spotify.com/artist/1Cs0zKBU1kc0i8ypK3B9ai then your user ID is 1Cs0zKBU1kc0i8ypK3B9ai.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_si_user_id'] ) && $btnsx_settings['social_counters_si_user_id'] != '' ? $btnsx_settings['social_counters_si_user_id'] : ''
										),
										array(
											'type'			=>	'select',
											'id'			=>	'social_counters_si_user_type',
											'name'			=>	'social_counters_si_user_type',
											'class'			=>	'btnsx-select',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Spotify User Type', 'btnsx' ),
											'tooltip'		=>	__( 'If your profile url is https://play.spotify.com/user/david_guetta_ then your user type is User. If your profile url is https://play.spotify.com/artist/1Cs0zKBU1kc0i8ypK3B9ai then your user type is Artist.', 'btnsx' ),
											'options'		=>	array(
												'artist'	=>	__( 'Artist', 'btnsx' ),
												'user'		=>	__( 'User', 'btnsx' )
											),
											'value'			=>	isset( $btnsx_settings['social_counters_si_user_type'] ) && $btnsx_settings['social_counters_si_user_type'] != '' ? $btnsx_settings['social_counters_si_user_type'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Steam', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_stm_user_id',
											'name'			=>	'social_counters_stm_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Steam Group ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the group ID. For example: If your group url is http://steamcommunity.com/groups/razorsharpgaming/ then your user ID is razorsharpgaming.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_stm_user_id'] ) && $btnsx_settings['social_counters_stm_user_id'] != '' ? $btnsx_settings['social_counters_stm_user_id'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Tumblr', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_tbr_api_key',
											'name'			=>	'social_counters_tbr_api_key',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Tumblr Consumer Key', 'btnsx' ),
											'tooltip'		=>	__( 'Complete information available here - <a target="_blank" href="https://gautamthapar.atlassian.net/wiki/display/BX/Tumblr">https://gautamthapar.atlassian.net/wiki/display/BX/Tumblr</a>.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_tbr_api_key'] ) && $btnsx_settings['social_counters_tbr_api_key'] != '' ? $btnsx_settings['social_counters_tbr_api_key'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_tbr_api_secret',
											'name'			=>	'social_counters_tbr_api_secret',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Tumblr Consumer Secret', 'btnsx' ),
											'tooltip'		=>	__( 'Complete information available here - <a target="_blank" href="https://gautamthapar.atlassian.net/wiki/display/BX/Tumblr">https://gautamthapar.atlassian.net/wiki/display/BX/Tumblr</a>.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_tbr_api_secret'] ) && $btnsx_settings['social_counters_tbr_api_secret'] != '' ? $btnsx_settings['social_counters_tbr_api_secret'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_tbr_token',
											'name'			=>	'social_counters_tbr_token',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Tumblr Token', 'btnsx' ),
											'tooltip'		=>	__( 'Complete information available here - <a target="_blank" href="https://gautamthapar.atlassian.net/wiki/display/BX/Tumblr">https://gautamthapar.atlassian.net/wiki/display/BX/Tumblr</a>.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_tbr_token'] ) && $btnsx_settings['social_counters_tbr_token'] != '' ? $btnsx_settings['social_counters_tbr_token'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_tbr_token_secret',
											'name'			=>	'social_counters_tbr_token_secret',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Tumblr Token Secret', 'btnsx' ),
											'tooltip'		=>	__( 'Complete information available here - <a target="_blank" href="https://gautamthapar.atlassian.net/wiki/display/BX/Tumblr">https://gautamthapar.atlassian.net/wiki/display/BX/Tumblr</a>.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_tbr_token_secret'] ) && $btnsx_settings['social_counters_tbr_token_secret'] != '' ? $btnsx_settings['social_counters_tbr_token_secret'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_tbr_user_id',
											'name'			=>	'social_counters_tbr_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Tumblr Blog ID', 'btnsx' ),
											'tooltip'		=>	__( 'If your profile URL is "http://lyricsandlife.tumblr.com/" then your ID is lyricsandlife.tumblr.com.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_tbr_user_id'] ) && $btnsx_settings['social_counters_tbr_user_id'] != '' ? $btnsx_settings['social_counters_tbr_user_id'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Twitch', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_twi_user_id',
											'name'			=>	'social_counters_twi_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Twitch Channel ID', 'btnsx' ),
											'tooltip'		=>	__( 'If your channel URL is "http://www.twitch.tv/towelliee/" then your channel ID is towelliee.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_twi_user_id'] ) && $btnsx_settings['social_counters_twi_user_id'] != '' ? $btnsx_settings['social_counters_twi_user_id'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Twitter', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_tw_consumer_key',
											'name'			=>	'social_counters_tw_consumer_key',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Twitter Consumer Key', 'btnsx' ),
											'tooltip'		=>	__( 'Complete information available here - <a target="_blank" href="https://gautamthapar.atlassian.net/wiki/display/BX/Twitter">https://gautamthapar.atlassian.net/wiki/display/BX/Twitter</a>.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_tw_consumer_key'] ) && $btnsx_settings['social_counters_tw_consumer_key'] != '' ? $btnsx_settings['social_counters_tw_consumer_key'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_tw_consumer_secret',
											'name'			=>	'social_counters_tw_consumer_secret',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Twitter Consumer Secret', 'btnsx' ),
											'tooltip'		=>	__( 'Complete information available here - <a target="_blank" href="https://gautamthapar.atlassian.net/wiki/display/BX/Twitter">https://gautamthapar.atlassian.net/wiki/display/BX/Twitter</a>.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_tw_consumer_secret'] ) && $btnsx_settings['social_counters_tw_consumer_secret'] != '' ? $btnsx_settings['social_counters_tw_consumer_secret'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_tw_username',
											'name'			=>	'social_counters_tw_username',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Twitter Username', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the twitter username. For example: if your profile URL is "https://twitter.com/Gautam_Thapar" then your ID is Gautam_Thapar.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_tw_username'] ) && $btnsx_settings['social_counters_tw_username'] != '' ? $btnsx_settings['social_counters_tw_username'] : ''
										),
										array(
											'type'			=>	'html',
											'value'			=>	( isset( $btnsx_settings['social_counters_tw_consumer_key'] ) && $btnsx_settings['social_counters_tw_consumer_key'] != '' ) && ( isset( $btnsx_settings['social_counters_tw_consumer_secret'] ) && $btnsx_settings['social_counters_tw_consumer_secret'] != '' ) ? '<a id="twitter-oauth" class="btn '.$tw_btn_class.'" href="" style="margin-left:10px;">'.$tw_btn_access.'</a>' : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Vimeo', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_vm_app_id',
											'name'			=>	'social_counters_vm_app_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Vimeo Access Token', 'btnsx' ),
											'tooltip'		=>	__( 'Please create an app on Vimeo through this link: <a target="_blank" href="https://developer.vimeo.com/apps/new">https://developer.vimeo.com/apps/new</a> and get this information.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_vm_app_id'] ) && $btnsx_settings['social_counters_vm_app_id'] != '' ? $btnsx_settings['social_counters_vm_app_id'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_vm_channel_id',
											'name'			=>	'social_counters_vm_channel_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Vimeo Channel ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the channel ID. For example:If your page url is https://vimeo.com/channels/kidproof then your channel ID is kidproof.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_vm_channel_id'] ) && $btnsx_settings['social_counters_vm_channel_id'] != '' ? $btnsx_settings['social_counters_vm_channel_id'] : ''
										),
									)
								),
								array(
									'text'	=>	__( 'Vine', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_vi_user_id',
											'name'			=>	'social_counters_vi_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Vine User ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter user ID. For example: If your profile url is https://vine.co/u/992596653741658112 then your user ID is 992596653741658112.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_vi_user_id'] ) && $btnsx_settings['social_counters_vi_user_id'] != '' ? $btnsx_settings['social_counters_vi_user_id'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'VK', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_vk_user_id',
											'name'			=>	'social_counters_vk_user_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'VK User/Group ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter user/group ID. For example: If your profile url is https://vk.com/durov then your user ID is durov.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_vk_user_id'] ) && $btnsx_settings['social_counters_vk_user_id'] != '' ? $btnsx_settings['social_counters_vk_user_id'] : ''
										),
										array(
											'type'			=>	'select',
											'id'			=>	'social_counters_vk_user_type',
											'name'			=>	'social_counters_vk_user_type',
											'placeholder'	=>	' ',
											'label'			=>	__( 'VK User Type', 'btnsx' ),
											'tooltip'		=>	__( 'Select user type.', 'btnsx' ),
											'options'		=>	array(
												'user'	=>	__( 'User', 'btnsx' ),
												'group'	=>	__( 'Community / Group', 'btnsx' )
											),
											'value'			=>	isset( $btnsx_settings['social_counters_vk_user_type'] ) && $btnsx_settings['social_counters_vk_user_type'] != '' ? $btnsx_settings['social_counters_vk_user_type'] : ''
										)
									)
								),
								array(
									'text'	=>	__( 'Youtube', 'btnsx' ),
									'elements'		=> array(
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_yt_app_id',
											'name'			=>	'social_counters_yt_app_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Youtube API Key', 'btnsx' ),
											'tooltip'		=>	__( 'To get your API Key, first create a project/app in <a target="_blank" href="https://console.developers.google.com/project">https://console.developers.google.com/project</a> and then turn on both Youtube Data and Analytics API from "APIs & auth >APIs inside your project.Then again go to "APIs & auth > APIs > Credentials > Public API access" and then click "CREATE A NEW KEY" button, select the "Browser key" option and click in the "CREATE" button, and then copy your API key and paste in above field.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_yt_app_id'] ) && $btnsx_settings['social_counters_yt_app_id'] != '' ? $btnsx_settings['social_counters_yt_app_id'] : ''
										),
										array(
											'type'			=>	'select',
											'id'			=>	'social_counters_yt_id_type',
											'name'			=>	'social_counters_yt_id_type',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Youtube ID Type', 'btnsx' ),
											'tooltip'		=>	__( 'Select whether to show subscribers based on username or channel ID.', 'btnsx' ),
											'options'		=>	array(
												'username'	=>	__( 'Username', 'btnsx' ),
												'channel'	=>	__( 'Channel ID', 'btnsx' )
											),
											'value'			=>	isset( $btnsx_settings['social_counters_yt_id_type'] ) && $btnsx_settings['social_counters_yt_id_type'] != '' ? $btnsx_settings['social_counters_yt_id_type'] : ''
										),
										array(
											'type'			=>	'text',
											'id'			=>	'social_counters_yt_channel_id',
											'name'			=>	'social_counters_yt_channel_id',
											'placeholder'	=>	' ',
											'label'			=>	__( 'Youtube Channel ID', 'btnsx' ),
											'tooltip'		=>	__( 'Please enter the channel ID or channel name.For example:If your channel url is https://www.youtube.com/channel/UC6NaI3lbMp249PmtRMajVjA then your channel ID is UC6NaI3lbMp249PmtRMajVjA.', 'btnsx' ),
											'value'			=>	isset( $btnsx_settings['social_counters_yt_channel_id'] ) && $btnsx_settings['social_counters_yt_channel_id'] != '' ? $btnsx_settings['social_counters_yt_channel_id'] : ''
										),
									)
								),
								
							),
						);
					}
					// filter to add custom options
		        	$btnsx_filtered_options = apply_filters( 'btnsx_settings_filter', array() );
		        	$btnsx_options = wp_parse_args( $btnsx_filtered_options, $btnsx_default_options );
		        	$btnsx_form_design->tabs(
		        		array(
		        			'id'			=>	'btnsx-tabs-0',
		        			'outer_group'	=>	$btnsx_options
		        		)
		        	);
		        	?>
		      	</div>
		      	<div class="col m12 l3">
		      		<div class="col s12 col-pad-css" style="display:none;">
		      			<button id="btnsx-settings-css-submit" name="btnsx-settings-css-submit" class="btn btn-save-css btn-settings" type="submit"><span id="btnsx-settings-css-text"><?php _e( 'Save & Regenerate CSS', 'btnsx' ); ?></span><span id="btnsx-settings-css-bg" style="width:<?php // echo isset($_POST['btnsx-settings-css-submit']) ? css_progress() : 0;?>%"></span></button>
		      		</div>
			        <div class="col s6 col-pad-settings">
				    	<button id="btnsx-settings-submit" class="btn btn-save btn-settings" type="submit"><?php _e( 'Save', 'btnsx' ); ?></button>
				    </div>
				    <div class="col s6 col-pad-settings">
				    	<button id="btnsx-settings-reset" class="btn btn-reset btn-settings" type="submit"><?php _e( 'Reset', 'btnsx' ); ?></button>
				    </div>
		      	</div>
		      	<div class="col m12 l3">
		      		<div class="help-links" style="padding: 10px;">
			      		<p><?php _e( 'Helpful Links:', 'btnsx' ); ?></p>
				        <ul>
				        	<li><a href="https://www.button.sx/product-category/add-ons/"><?php _e( 'Button Add-ons', 'btnsx' ); ?></a></li>
				        	<li><a target="_blank" href="https://www.button.sx/product-category/packs/"><?php _e( 'Button Packs', 'btnsx' ); ?></a></li>
				        	<li><a target="_blank" href="https://gautamthapar.atlassian.net/wiki/display/BX/"><?php _e( 'Documentation', 'btnsx' ); ?></a></li>
				        	<li><a target="_blank" href="http://gautamthapar.ticksy.com"><?php _e( 'Support', 'btnsx' ); ?></a></li>
				        	<li><a target="_blank" href="https://www.button.sx/"><?php _e('Official Website','btnsx'); ?></a></li>
				        	<li><a target="_blank" href="https://twitter.com/Gautam_Thapar"><?php _e('Twitter','btnsx'); ?></a></li>
				        </ul>
				    </div>
		      	</div>
	      	</form>
	    </div>
	</div>

</div>